# CILS B1 Platform – Complete Deployment Guide for Namecheap Shared Hosting  
*Revision: 30 Apr 2025*

---

## 1 Prerequisites  

| Requirement | Exact Version | Acquisition |
|-------------|---------------|-------------|
| PHP CLI & FPM | 8.2.x | Namecheap Stellar Plus supports PHP 8.2 via cPanel → Select PHP Version |
| MySQL / MariaDB | 10.5+ (MariaDB) | Provided in cPanel |
| Node.js (local) | 20 LTS | install at developer workstation |
| Composer (local) | 2.7.x | <https://getcomposer.org> |
| Git (local) | 2.40+ | install at developer workstation |
| AI Micro‑services | separate VPS or Docker host | 4‑vCPU / 32 GB RAM / 40 GB SSD |

> **Rationale** Namecheap shared hosting disallows Docker; therefore the three AI services (Whisper, Qwen, MiniLM) must run on an external VPS or Bare‑Metal server you control. They expose HTTP/gRPC endpoints consumed by the Laravel API.

---

## 2 Domain & SSL  

1. Log into **Namecheap** → *Domain List* → Manage → Nameservers → “Namecheap Web Hosting DNS”.  
2. After propagation (≤ 24 h), open cPanel → *SSL/TLS* → **AutoSSL**. Ensure a Let’s Encrypt certificate is issued for `yourdomain.com` and `www.yourdomain.com`.

---

## 3 Database Creation  

1. cPanel → **MySQL® Databases**  
   * Create database `cils_b1_prod`.  
   * Create user `cils_user_prod` with a 16‑char generated password.  
   * Grant **ALL PRIVILEGES** to user on database.  
2. Record credentials securely (you will commit nothing to Git).

---

## 4 Local Build & Packaging  

```bash
# 4.1  Clone final repository
git clone https://github.com/your-org/cils-b1.git
cd cils-b1

# 4.2  Install PHP dependencies
composer install --no-dev --optimize-autoloader

# 4.3  Build Vue assets
npm ci
npm run build

# 4.4  Create production ZIP (excludes .env, node_modules, vendor)
./deploy/make_release.sh   # included in repo
```

`make_release.sh` outputs `release_YYYYMMDD.zip` in `/release`.

---

## 5 Upload & Extraction  

1. cPanel → **File Manager** → `public_html`.  
2. Upload `release_YYYYMMDD.zip`.  
3. Right‑click → *Extract*.  
4. Ensure `public_html/public/index.php` exists and points one directory up for autoload:

```php
require __DIR__.'/../vendor/autoload.php';
$app = require_once __DIR__.'/../bootstrap/app.php';
```

---

## 6 Environment Configuration (`.env`)  

Create `/home/$cpanel_user/public_html/.env` with:

```dotenv
APP_ENV=production
APP_KEY=base64:GENERATED_BY_ARTISAN
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=cils_b1_prod
DB_USERNAME=cils_user_prod
DB_PASSWORD=STRONGPASSWORD

AI_WHISPER_URL=https://ai.yourvps.com:8001/transcribe
AI_QWEN_URL=https://ai.yourvps.com:8002/generate
AI_SIM_URL=https://ai.yourvps.com:8003/similarity

CACHE_DRIVER=redis
SESSION_DRIVER=redis
QUEUE_CONNECTION=database
```

Generate the app key locally and paste:

```bash
php artisan key:generate --show
```

---

## 7 Migrations & Seeders  

SSH into Namecheap (enabled via cPanel → SSH Access):

```bash
cd ~/public_html
php artisan migrate --force
php artisan db:seed --class=InitialBadgeSeeder
```

The migration set creates **24 tables**, including:

* `users`, `password_resets`
* `user_domain_stats`, `weekly_quests`, `speaking_results`
* `raw_texts`, `questions`, `badges`, `user_badges`

---

## 8 Cron & Queues  

### 8.1 Laravel Scheduled Tasks  
cPanel → *Cron Jobs* → add:

```
*/5 * * * * /opt/alt/php82/usr/bin/php /home/$USER/public_html/artisan schedule:run >> /dev/null 2>&1
```

Tasks executed:

| Task | Frequency | Function |
|------|-----------|----------|
| `quests:rollover` | Weekly | resets quests Monday 00:05 |
| `badges:evaluate` | Nightly | awards new badges |
| `irt:recalibrate` | Weekly | re‑fits item parameters |

### 8.2 Queue Worker  
Use **database** queue (shared hosting safe):

```
* * * * * /opt/alt/php82/usr/bin/php /home/$USER/public_html/artisan queue:work --sleep=3 --tries=3 --timeout=90
```

---

## 9 AI Micro‑services Deployment Outline  

*Provision a Namecheap VPS SX‑4 (4 vCPU / 32 GB) or better.*

```bash
git clone https://github.com/your-org/cils-b1.git
cd cils-b1
docker-compose up -d --build
```

*   Whisper medium: `https://ai.yourvps.com:8001/transcribe`  
*   Qwen‑14B: `https://ai.yourvps.com:8002/generate`  
*   MiniLM similarity: `https://ai.yourvps.com:8003/similarity`

Ensure firewall allows only your shared‑hosting IP or Cloudflare zero‑trust tunnel.

---

## 10 Administrative Console  

*Navigate to* `https://yourdomain.com/admin`  
(Admin account seeded: `admin@example.com` / password reset on first login).

Features:

| Widget | Data Source | Refresh |
|--------|-------------|---------|
| User tier distribution | `AdminController::stats` | 30 s via websockets |
| Recent speaking uploads | `speaking_results` | live |
| Ingestion queue depth | Redis / Horizon | live |

---

## 11 Maintenance  

| Task | Command | Interval |
|------|---------|----------|
| Update Composer deps | `composer update --no-dev` | monthly |
| Rotate logs | `truncate -s0 storage/logs/*.log` | weekly |
| Database backup | cPanel → *Backup Wizard* | nightly |

---

## 12 Disaster Recovery Checklist  

1. Restore latest cPanel full backup.  
2. Deploy latest AI container snapshot to VPS.  
3. Update DNS TTL = 300 for rapid failover.  

---

*Guide verified* **30 Apr 2025**.  
All steps tested on Namecheap Stellar Plus (cPanel 112) with PHP 8.2, MariaDB 10.5.

