
# Publishing the CILS B1 App

This guide explains how to wrap the existing PWA with Capacitor and publish on the **Apple App Store** and **Google Play**.

---

## 1 Prerequisites

| Item | Apple | Google |
|------|-------|--------|
| Developer account | Apple Developer Program – **US $99/year** citeturn0search0 | Google Play Console – **US $25 one-time** citeturn0search1 |
| macOS & Xcode | Required for iOS build | — |
| Android Studio | — | Required |
| Capacitor CLI | `npm i -g @capacitor/cli` | Same |

---

## 2 Wrap PWA with Capacitor

```bash
npm install @capacitor/core @capacitor/ios @capacitor/android
npx cap init "CILS B1 Prep" com.yourcompany.cilsb1
npm run build      # Vite build → dist
npx cap copy
```

### iOS

```bash
npx cap open ios   # opens Xcode
# Set icons, splash, Version, Build
Product ▸ Archive ▸ Distribute via App Store
```

### Android

```bash
npx cap open android
# Generate Signed Bundle (Google Play) – keystore, versionCode
```

---

## 3 App Store Requirements

* **App Review Guidelines** sections 3.1.1 (payments) and 3.2 (data) citeturn0search2.  
* Subscription price tiers set in App Store Connect; free trial configured as `Introductory Offer`.

---

## 4 Google Play Requirements

* Privacy policy URL in Play Console.  
* Ads must comply with **Google Ads policies** (e.g., no deceptive placement) citeturn0search3.  
* Target API level 34+; set `android:exported` in `AndroidManifest.xml`.

---

## 5 Ongoing Compliance

* Keep PWA manifest versions in sync with store version numbers.  
* Remember to update screenshots whenever UI changes.  
* Use AppTweak benchmarks: 25 % App Store conversion, 27 % Play conversion citeturn0search5.

