
# 📱 Mobile App Deployment Guide (Capacitor)

---

## 1. What This Does
This wrapper turns your Vue frontend into installable mobile apps for:
- ✅ iOS (Apple App Store)
- ✅ Android (Google Play)

---

## 2. Requirements

| Platform | Requirements |
|----------|--------------|
| iOS | macOS + Xcode + Apple Developer account ($99/year) |
| Android | Android Studio + Google Play Console account ($25 one-time) |

---

## 3. Setup (Common)

1. From root of your project:
```bash
npm install --save @capacitor/core @capacitor/cli
npx cap init "CILS B1 Prep" com.altoadige.cils
npm run build
npx cap copy
```

---

## 4. iOS Build

```bash
npx cap add ios
npx cap open ios  # opens Xcode

# Inside Xcode:
# - Set display name, app version, app icons
# - Archive → Distribute via App Store Connect
```

---

## 5. Android Build

```bash
npx cap add android
npx cap open android  # opens Android Studio

# Inside Android Studio:
# - Set versionCode/versionName
# - Generate Signed APK or AAB
# - Upload to Google Play Console
```

---

## 6. Stripe, Webhooks, Login

- Login, email, audio, and subscription all work via your domain.
- This is a wrapper — **no logic is duplicated**. All backend and payments stay in Laravel.

---

## 7. Admin Access

In `/admin/mobile`:
- View current app manifest and metadata
- Edit PWA display name and splash icon
- See download stats (if bundled with analytics)
- Switch default app environments (dev, prod, staging)

