module.exports = {
  globDirectory: 'public',
  globPatterns: [
    'index.php',              // ← your Laravel front‐controller
    'manifest.json',          // ← the manifest you have just created
    'build/**/*.{js,css}'     // ← your hashed JS/CSS bundles
  ],
  swDest: 'public/sw.js',
  clientsClaim: true,
  skipWaiting: true,
  runtimeCaching: [
    {
      urlPattern: ({ request }) => request.destination === 'document',
      handler: 'NetworkFirst',
      options: {
        cacheName: 'html-cache',
        expiration: {
          maxEntries: 10,
          maxAgeSeconds: 24 * 60 * 60
        }
      }
    }
  ]
};
