<?php
namespace App\Api;

use Illuminate\Support\Facades\DB;

class AdminController {
  public function stats(){
    $tiers = DB::table('user_season_stats')
      ->selectRaw('CASE WHEN season_xp>=7000 THEN "Platinum" WHEN season_xp>=3000 THEN "Gold" WHEN season_xp>=1000 THEN "Silver" ELSE "Bronze" END as tier, COUNT(*) as total')
      ->groupBy('tier')->pluck('total','tier')->toArray();
    return ['usersByTier'=>array_map(fn($k,$v)=>['name'=>$k,'value'=>$v],array_keys($tiers),array_values($tiers))];
  }
}
