<?php
class AuthController
{
    public static function login()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        $email = $data['email'];
        $password = $data['password'];

        $user = User::findByEmail($email);
        if ($user && password_verify($password, $user['password'])) {
            $token = Auth::createSession($user['id']);
            echo json_encode(['success' => true, 'token' => $token]);
        } else {
            echo json_encode(['success' => false]);
        }
    }

    public static function register()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        $user = User::create($data['email'], $data['password']);
        echo json_encode(['success' => !!$user]);
    }

    public static function logout()
    {
        Auth::destroySession();
        echo json_encode(['success' => true]);
    }

    public static function forgotPassword()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        Mailer::sendPasswordReset($data['email']);
        echo json_encode(['success' => true]);
    }
}
?>
