<?php
class UserController
{
    public static function profile()
    {
        $user = Auth::user();
        echo json_encode($user);
    }

    public static function flashcardRandom()
    {
        $flashcard = Flashcard::random();
        echo json_encode($flashcard);
    }

    public static function flashcardAnswer()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        Flashcard::recordAnswer($data['id'], $data['answer']);
        echo json_encode(['success' => true]);
    }

    public static function subscription()
    {
        $sub = Subscription::current(Auth::user()['id']);
        echo json_encode($sub);
    }

    public static function cancelSubscription()
    {
        Subscription::cancel(Auth::user()['id']);
        echo json_encode(['success' => true]);
    }
}
?>
