<?php
namespace App\Api;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class WordEmailController{
    public function index(){
        return [
            'words'=>DB::table('word_queue')->orderByDesc('id')->get(),
            'ads'=>DB::table('ad_creatives')->orderBy('sort_order')->get(),
            'template'=>DB::table('settings')->where('key','email_template')->value('value')??''
        ];
    }
    public function storeWord(Request $r){
        $id=DB::table('word_queue')->insertGetId($r->only(['lemma','definition','example']));
        return DB::table('word_queue')->find($id);
    }
    public function saveTemplate(Request $r){
        DB::table('settings')->updateOrInsert(['key'=>'email_template'],['value'=>$r->getContent()]);
        return ['status'=>'ok'];
    }
    public function saveAds(Request $r){
        foreach($r->json()->all() as $i=>$ad){
            DB::table('ad_creatives')->where('id',$ad['id'])->update(['sort_order'=>$i,'tier'=>$ad['tier']]);
        }
        return ['status'=>'ok'];
    }
}
