// app/Http/Controllers/Api/AlertController.php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Alert;
use Illuminate\Http\Request;

class AlertController extends Controller
{
    // Only active, currently valid alerts for the user
    public function index(Request $request)
    {
        $userId = $request->user()->id ?? null;
        $now = now();
        $alerts = Alert::where('active', true)
            ->where(function ($q) use ($now) {
                $q->whereNull('starts_at')->orWhere('starts_at', '<=', $now);
            })
            ->where(function ($q) use ($now) {
                $q->whereNull('ends_at')->orWhere('ends_at', '>=', $now);
            })
            ->where(function ($q) use ($userId) {
                $q->whereNull('user_id')->orWhere('user_id', $userId);
            })
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json($alerts);
    }

    // Admin: create/update/destroy methods can be scaffolded as needed
}
