<?php
namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use App\Services\QuestionParser;

class IngestFileJob implements ShouldQueue
{
    use Dispatchable, Queueable;

    public function __construct(public string $diskPath, public int $userId){}

    public function handle(QuestionParser $parser): void
    {
        $ext = Str::lower(pathinfo($this->diskPath, PATHINFO_EXTENSION));

        if (in_array($ext, ['zip'])) {
            $parser->parseZip($this->diskPath, $this->userId);
        } elseif (in_array($ext, ['pdf','docx','txt'])) {
            $parser->parseDocument($this->diskPath, $this->userId);
        } elseif (in_array($ext, ['mp3','wav','ogg','mp4'])) {
            $parser->parseAudio($this->diskPath, $this->userId);
        }
    }
}
