<?php
declare(strict_types=1);

namespace App\Services;

use Illuminate\Support\Facades\Storage;
use Smalot\PdfParser\Parser as PdfParser;
use Illuminate\Support\Facades\DB;

class ParserService
{
    public function parseAndPersist(string $path, int $userId): void
    {
        $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
        match ($ext) {
            'pdf' => $this->parsePdf($path),
            'txt' => $this->parseTxt($path),
            'zip' => $this->parseZip($path, $userId),
            default => null,
        };
    }

    private function parsePdf(string $path): void
    {
        $parser = new PdfParser();
        $pdf = $parser->parseFile(Storage::path($path));
        $text = $pdf->getText();
        DB::table('raw_texts')->insert(['content'=>$text,'source'=>$path]);
    }

    private function parseTxt(string $path): void
    {
        $text = Storage::get($path);
        DB::table('raw_texts')->insert(['content'=>$text,'source'=>$path]);
    }

    private function parseZip(string $path, int $userId): void
    {
        $zip = new \ZipArchive();
        $zip->open(Storage::path($path));
        for ($i=0; $i<$zip->numFiles; $i++) {
            $name = $zip->getNameIndex($i);
            $tmpPath = Storage::path('tmp/'.uniqid().'/'.$name);
            copy("zip://".Storage::path($path)."#".$name, $tmpPath);
            dispatch(new IngestJob('tmp/'.$name, $userId));
        }
        $zip->close();
    }
}
