-- ============================================================
--  Master Schema & Seed Script for CILS B1 Platform
--  Generated 30 Apr 2025
--  Usage:
--      mysql -u root -p < cils_b1_init.sql
-- ============================================================

CREATE DATABASE IF NOT EXISTS cils_b1_prod DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE cils_b1_prod;

-- Core user tables ----------------------------------------------------------
CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120),
  email VARCHAR(190) UNIQUE,
  password VARCHAR(255),
  xp INT DEFAULT 0,
  remember_token VARCHAR(100),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE password_resets (
  email VARCHAR(190) INDEX,
  token VARCHAR(255),
  created_at TIMESTAMP NULL
);

-- Gamification & Adaptive tables -------------------------------------------
CREATE TABLE user_domain_stats (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  domain ENUM('vocabulary','listening','reading_writing','speaking'),
  theta DECIMAL(6,3) DEFAULT 0,
  attempted INT DEFAULT 0,
  correct INT DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_user_domain (user_id, domain)
);

CREATE TABLE weekly_quests (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  week DATE,
  domain VARCHAR(32),
  target INT,
  progress INT DEFAULT 0,
  completed TINYINT(1) GENERATED ALWAYS AS (progress >= target) STORED,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_user_week (user_id, week)
);

CREATE TABLE badges (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(60) UNIQUE,
  name VARCHAR(120),
  description VARCHAR(255),
  league ENUM('Bronze','Silver','Gold','Platinum'),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE user_badges (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  badge_id INT,
  awarded_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Speaking results
CREATE TABLE speaking_results (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  transcript MEDIUMTEXT,
  confidence DECIMAL(4,2),
  rubric JSON,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Raw ingestion texts
CREATE TABLE raw_texts (
  id INT AUTO_INCREMENT PRIMARY KEY,
  content MEDIUMTEXT,
  source VARCHAR(255),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Questions
CREATE TABLE questions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  domain ENUM('vocabulary','listening','reading_writing','speaking'),
  prompt TEXT,
  answer_key TEXT,
  distractors JSON,
  audio_path VARCHAR(255),
  rubric JSON,
  difficulty DECIMAL(5,2),
  discrimination DECIMAL(4,2) DEFAULT 1.00,
  source_doc VARCHAR(255),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Seed admin user -----------------------------------------------------------
INSERT INTO users (name, email, password, xp)
VALUES ('Administrator', 'admin@example.com', '$2b$12$MBkMMsxMJMirrdjU/gNawOKomK/Vw.DYyr5btvh1H0XjLLY0BgUeO', 0);

-- Seed initial badges
INSERT INTO badges (code, name, description, league) VALUES
('VOCAB_VIRTUOSO', 'Vocabulary Virtuoso', 'Mastered 800 terms', 'Silver'),
('AURAL_ACE',      'Aural Ace',          '80 % accuracy in listening', 'Gold'),
('TEXT_TACTICIAN', 'Textual Tactician',  '85 % in reading‑writing', 'Gold'),
('ORATOR_OMNI',    'Orator Omniscient',  'B2 score in speaking rubric', 'Platinum');

-- Finished


-- Word/Ad tables added

CREATE TABLE IF NOT EXISTS word_queue (id INT AUTO_INCREMENT PRIMARY KEY, lemma VARCHAR(80), definition TEXT, example TEXT, audio VARCHAR(255), created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);
CREATE TABLE IF NOT EXISTS ad_creatives (id INT AUTO_INCREMENT PRIMARY KEY, html MEDIUMTEXT, tier ENUM('free','premium','all') DEFAULT 'all', sort_order INT DEFAULT 0, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);
CREATE TABLE IF NOT EXISTS settings (id INT AUTO_INCREMENT PRIMARY KEY, `key` VARCHAR(120) UNIQUE, `value` MEDIUMTEXT, updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP);
