<?php
// database/migrations/2024_01_01_000000_create_alerts_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAlertsTable extends Migration
{
    public function up()
    {
        Schema::create('alerts', function (Blueprint $table) {
            $table->id();
            $table->string('type')->default('info'); // info, success, error, warning
            $table->string('title')->nullable();
            $table->text('message');
            $table->unsignedBigInteger('user_id')->nullable(); // Optional: null = all users, otherwise targeted
            $table->json('meta')->nullable(); // For lessonId, link, extra context, etc.
            $table->timestamp('starts_at')->nullable(); // For scheduling
            $table->timestamp('ends_at')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('alerts');
    }
}
