-- Migration: create_user_domain_stats.sql
CREATE TABLE IF NOT EXISTS user_domain_stats (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  domain ENUM('vocabulary','listening','reading_writing','speaking') NOT NULL,
  theta DECIMAL(5,2) DEFAULT 0.00,
  attempted INT DEFAULT 0,
  correct INT DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_user_domain (user_id, domain)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Migration: create_weekly_quests.sql
CREATE TABLE IF NOT EXISTS weekly_quests (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  week DATE NOT NULL,
  domain VARCHAR(32),
  target INT NOT NULL,
  progress INT DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_user_week (user_id, week)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
