<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Setting;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash; // We need this for the password

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Use updateOrCreate to safely create or update the admin user.
        // It looks for a user with this email, if not found, it creates them.
        User::updateOrCreate(
            ['email' => 'admin@example.com'], // The unique value to look for
            [
                'name' => 'Admin User',
                'password' => Hash::make('password'), // Set a default password
            ]
        );

        // Use updateOrCreate for settings as well.
        // This looks for the first row and updates it, or creates it if none exist.
        Setting::updateOrCreate(
            ['id' => 1], // Usually, there's only one settings row.
            [
                'name' => 'My Awesome Site',
                'logo' => 'images/logo.png',
                'favicon' => 'images/favicon.ico',
            ]
        );
    }
}