/*
  Copyright © 2025 Alto Adige, LLC, Austin, Texas.
  All rights reserved. This file is part of a licensed system protected under international law.
  Unauthorized copying or distribution of this file, via any medium, is strictly prohibited.
  For legal inquiries contact: legal@altoadige.ai
*/


from fastapi import FastAPI
from pydantic import BaseModel
from transformers import pipeline

app = FastAPI()
generator = pipeline("text-generation", model="Qwen/Qwen-1_8B-Chat", device_map="auto")

class Prompt(BaseModel):
    passage:str
    n:int=4

@app.post("/generate")
def generate(p:Prompt):
    prompt = f"Create {p.n} CILS B1-level multiple-choice questions (with 4 options each, correct answer marked with *) from the following passage:\n{p.passage}"
    out = generator(prompt, max_length=512)[0]["generated_text"]
    return {"questions": out}
