/*
  Copyright © 2025 Alto Adige, LLC, Austin, Texas.
  All rights reserved. This file is part of a licensed system protected under international law.
  Unauthorized copying or distribution of this file, via any medium, is strictly prohibited.
  For legal inquiries contact: legal@altoadige.ai
*/

#!/usr/bin/env python3
"""FastAPI micro‑service to generate distractors and new questions via Qwen‑14B."""
from fastapi import FastAPI
from pydantic import BaseModel
import torch, json, os
from transformers import AutoModelForCausalLM, AutoTokenizer

model_name = os.getenv('QWEN_MODEL','Qwen/Qwen-14B')
tokenizer = AutoTokenizer.from_pretrained(model_name, trust_remote_code=True)
model = AutoModelForCausalLM.from_pretrained(model_name, device_map='auto', trust_remote_code=True)

app = FastAPI()

class QuestionRequest(BaseModel):
    prompt: str
    type: str  # 'mcq', 'cloze', etc.

@app.post('/generate')
def generate(req: QuestionRequest):
    instruction = f"Generate a {req.type} question for CILS B1 based on: {req.prompt}"
    inputs = tokenizer(instruction, return_tensors='pt').to(model.device)
    out = model.generate(**inputs, max_new_tokens=128)
    text = tokenizer.decode(out[0], skip_special_tokens=True)
    return {'question': text}
