/*
  Copyright © 2025 Alto Adige, LLC, Austin, Texas.
  All rights reserved. This file is part of a licensed system protected under international law.
  Unauthorized copying or distribution of this file, via any medium, is strictly prohibited.
  For legal inquiries contact: legal@altoadige.ai
*/


from fastapi import FastAPI
from pydantic import BaseModel
from sentence_transformers import SentenceTransformer, util

model = SentenceTransformer('sentence-transformers/all-MiniLM-L6-v2')
app = FastAPI()

class Pair(BaseModel):
    reference:str
    answer:str

@app.post("/score")
def score(p:Pair):
    emb1 = model.encode(p.reference, convert_to_tensor=True)
    emb2 = model.encode(p.answer, convert_to_tensor=True)
    sim = float(util.cos_sim(emb1, emb2)[0])
    return {"similarity": sim}
