/*
  Copyright © 2025 Alto Adige, LLC, Austin, Texas.
  All rights reserved. This file is part of a licensed system protected under international law.
  Unauthorized copying or distribution of this file, via any medium, is strictly prohibited.
  For legal inquiries contact: legal@altoadige.ai
*/

#!/usr/bin/env python3
"""Sentence similarity scoring via MiniLM."""
from fastapi import FastAPI
from pydantic import BaseModel
from sentence_transformers import SentenceTransformer, util

model = SentenceTransformer('all-MiniLM-L6-v2')
app = FastAPI()

class Pair(BaseModel):
    a: str
    b: str

@app.post('/similarity')
def sim(p: Pair):
    emb = model.encode([p.a, p.b])
    score = float(util.cos_sim(emb[0], emb[1]))
    return {'score': score}
