/*
  Copyright © 2025 Alto Adige, LLC, Austin, Texas.
  All rights reserved. This file is part of a licensed system protected under international law.
  Unauthorized copying or distribution of this file, via any medium, is strictly prohibited.
  For legal inquiries contact: legal@altoadige.ai
*/


from fastapi import FastAPI, UploadFile, File
import whisper
import torch, json, os
from pydantic import BaseModel
from transformers import pipeline

MODEL_NAME = os.getenv("WH_MODEL", "base")
wh_model = whisper.load_model(MODEL_NAME)

rubric_prompt = """You are an examiner. Evaluate the following Italian answer against the CILS B1 speaking rubric. 
Provide JSON with keys: fluency, lexical_range, grammar, overall (0-100)."""
gpt = pipeline("text-generation", model="gpt2", max_length=256)

app = FastAPI()

class Rubric(BaseModel):
    fluency:int
    lexical_range:int
    grammar:int
    overall:int

@app.post("/grade", response_model=Rubric)
async def grade(file: UploadFile = File(...)):
    audio_bytes = await file.read()
    with open("/tmp/input.wav","wb") as f:
        f.write(audio_bytes)
    result = wh_model.transcribe("/tmp/input.wav", language="it")
    text = result["text"].strip()
    prompt = rubric_prompt + "\nAnswer: " + text + "\nJSON:"
    out = gpt(prompt)[0]["generated_text"].split("JSON:")[-1]
    data = json.loads(out)
    return data
