/// <reference types="cypress" />
/// <reference types="node" />
import type { UserConfig } from 'vite-6';
declare const ALL_FRAMEWORKS: readonly ["react", "vue"];
type ConfigHandler = UserConfig | (() => UserConfig | Promise<UserConfig>);
export type ViteDevServerConfig = {
    specs: Cypress.Spec[];
    cypressConfig: Cypress.PluginConfigOptions;
    devServerEvents: NodeJS.EventEmitter;
    onConfigNotFound?: (devServer: 'vite', cwd: string, lookedIn: string[]) => void;
} & {
    framework?: typeof ALL_FRAMEWORKS[number];
    viteConfig?: ConfigHandler;
};
export declare function devServer(config: ViteDevServerConfig): Promise<Cypress.ResolvedDevServerConfig>;
export declare namespace devServer {
    var create: (devServerConfig: ViteDevServerConfig, vite: typeof import("vite-6")) => Promise<import("vite-6").ViteDevServer>;
}
export {};
