// resources/js/app.js

// 1. Import global CSS (Tailwind directives, resets, etc.)
import '../css/app.css';

import { createApp } from 'vue';
import { createPinia } from 'pinia';
import router from './router';
import App from './App.vue';

// 2. Import and register ECharts component
import VueECharts from 'vue-echarts';

// 3. Import and register Draggable component
import Draggable from 'vuedraggable';

// 4. Import and hydrate auth store
import { useAuthStore } from './stores/auth';

(async () => {
  // 5. Create the Vue application instance
  const app = createApp(App);

  // 6. Install Pinia before the router
  app.use(createPinia());

  // 7. Hydrate auth store before installing router
  const auth = useAuthStore();
  await auth.hydrate();

  // 8. Install the router (now that auth state is known)
  app.use(router);

  // 9. Globally register plugins and components
  app.component('v-chart', VueECharts);
  app.component('Draggable', Draggable);

  // 10. Mount the application
  app.mount('#app');

  // 11. Diagnostic breadcrumb
  console.log('▶ app.js executed, auth hydrated, and Vue mounted');
})();
