// resources/js/axios.js

import axios from 'axios'

// Ensure that cookies (for Sanctum CSRF) are sent on each request
axios.defaults.withCredentials = true

// Set the base URL for all API calls
axios.defaults.baseURL = '/api'

// Optional: attach an interceptor to automatically request CSRF cookie
axios.interceptors.request.use(async config => {
  // Before the first request to /api/*, get the CSRF token from Sanctum
  await axios.get('/sanctum/csrf-cookie')
  return config
})

export default axios
