// resources/js/stores/auth.js
import { defineStore } from 'pinia';
import axios from 'axios';
import router from '@/router';

export const useAuthStore = defineStore('auth', {
  state: () => ({
    user: null,
    isAuthenticated: false,
  }),
  actions: {
    async hydrate() {
      try {
        const { data } = await axios.get('/api/user');
        this.user = data;
        this.isAuthenticated = true;
      } catch {
        this.user = null;
        this.isAuthenticated = false;
      }
    },
    async login(credentials) {
      // CSRF cookie for Laravel Sanctum
      await axios.get('/sanctum/csrf-cookie');
      // Send login request
      await axios.post('/login', credentials);
      // Fetch authenticated user
      const { data } = await axios.get('/api/user');
      this.user = data;
      this.isAuthenticated = true;
      // Redirect based on role
      if (this.user.is_admin) {
        router.replace('/admin/admin-dashboard');
      } else {
        router.replace('/');
      }
    },
    async register(details) {
      await axios.get('/sanctum/csrf-cookie');
      await axios.post('/register', details);
      // Auto-login new user
      await this.login({ email: details.email, password: details.password });
    },
    async logout() {
      await axios.post('/logout');
      this.user = null;
      this.isAuthenticated = false;
      router.replace('/login');
    },
    async requestPasswordReset(email) {
      await axios.post('/password/email', { email });
    },
    async resetPassword(payload) {
      // payload: { token, email, password, password_confirmation }
      await axios.post('/password/reset', payload);
      // After reset, redirect to login
      router.replace('/login');
    }
  }
});