{{-- resources/views/app.blade.php --}}
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="scroll-smooth antialiased">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <title>@yield('title','CILS B1 Platform – App')</title>
    <meta name="description" content="@yield('description','Preparazione digitale CILS B1 con AI, flashcard, simulazioni e supporto multilingua.')" />
    <meta name="theme-color" content="#0055A4" />

    {{-- Manifest & Favicons --}}
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('icons/apple-touch-icon.png') }}" />
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('icons/favicon-32x32.png') }}" />
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('icons/favicon-16x16.png') }}" />
    <link rel="manifest" href="{{ asset('manifest.json') }}" />

    {{-- Vite loads your SPA entrypoint, plus CSS --}}
    @vite('src/main.js')
</head>
<body class="bg-italy-white text-navy-900 font-sans dark:bg-navy-900 dark:text-italy-white min-h-screen">

    {{-- SPA Mount Point --}}
    <div id="app"></div>

    {{-- Service Worker Registration (PWA/Offline Support) --}}
    <script type="module">
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () =>
                navigator.serviceWorker.register('/sw.js')
            );
        }
    </script>
    {{-- Ionicons (if your SPA uses them) --}}
    <script type="module"
        src="https://unpkg.com/ionicons@6.0.3/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule
        src="https://unpkg.com/ionicons@6.0.3/dist/ionicons/ionicons.js"></script>
</body>
</html>
