{{-- resources/views/contact.blade.php --}}
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contattaci – CILS B1 Platform</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-italy-white dark:bg-navy-900 text-navy-900 dark:text-italy-white font-sans antialiased min-h-screen flex flex-col">
    <<x-header>Contact Us</x-header> 

    <main class="flex-grow container mx-auto px-4 py-16 flex flex-col items-center justify-center">
        <div class="bg-white dark:bg-navy-800 shadow-xl rounded-lg p-8 w-full max-w-lg">
            <h1 class="text-3xl font-bold text-italy-blue mb-6 text-center">Contattaci</h1>
            <p class="mb-6 text-center text-gray-700 dark:text-gray-200">
                Per qualsiasi domanda, richiesta di supporto o informazione, compila il modulo qui sotto. Ti risponderemo al più presto.
            </p>
            <form method="POST" action="{{ route('contact') }}" class="space-y-6">
                @csrf
                <div>
                    <label for="name" class="block font-semibold mb-2">Nome</label>
                    <input id="name" name="name" type="text" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <div>
                    <label for="email" class="block font-semibold mb-2">Email</label>
                    <input id="email" name="email" type="email" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <div>
                    <label for="message" class="block font-semibold mb-2">Messaggio</label>
                    <textarea id="message" name="message" rows="5" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"></textarea>
                </div>
                <button type="submit"
                        class="w-full py-3 bg-italy-blue text-white font-semibold rounded-lg shadow hover:bg-blue-700 transition">
                    Invia Messaggio
                </button>
            </form>
            <p class="mt-6 text-center text-gray-700 dark:text-gray-200">
                Oppure scrivici a <a href="mailto:supporto@cils04.example" class="text-italy-blue underline">supporto@cils04.example</a>
            </p>
        </div>
    </main>

    @include('partials.footer')
</body>
</html>
