{{-- resources/views/components/header.blade.php --}}
@props(['url' => config('app.url')])

<header class="bg-white shadow-sm py-4 mb-8">
    <div class="container mx-auto px-4 md:px-6">
        <div class="flex justify-between items-center">
            <a href="{{ $url }}" class="text-[#0055A4] font-bold text-xl">
                @if (trim($slot) === 'Laravel')
                    <img src="{{ asset('icons/apple-touch-icon.png') }}" alt="CILS B1 Logo" class="h-10 w-auto">
                @else
                    {{ $slot }}
                @endif
            </a>
            
            <nav class="hidden md:flex space-x-6">
                <a href="{{ url('/') }}" class="text-gray-800 hover:text-[#0055A4]">Home</a>
                <a href="{{ url('/register') }}" class="text-gray-800 hover:text-[#0055A4]">Register</a>
                <a href="{{ url('/contact') }}" class="text-gray-800 hover:text-[#0055A4]">Contact</a>
                <a href="{{ url('/support') }}" class="text-gray-800 hover:text-[#0055A4]">Support</a>
            </nav>
            
            <div class="md:hidden">
                <button id="mobile-menu-button" class="text-gray-800 hover:text-[#0055A4]">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
            </div>
        </div>
        
        <!-- Mobile menu (hidden by default) -->
        <div id="mobile-menu" class="md:hidden hidden mt-4">
            <nav class="flex flex-col space-y-4">
                <a href="{{ url('/') }}" class="text-gray-800 hover:text-[#0055A4]">Home</a>
                <a href="{{ url('/register') }}" class="text-gray-800 hover:text-[#0055A4]">Register</a>
                <a href="{{ url('/contact') }}" class="text-gray-800 hover:text-[#0055A4]">Contact</a>
                <a href="{{ url('/support') }}" class="text-gray-800 hover:text-[#0055A4]">Support</a>
            </nav>
        </div>
    </div>
</header>

<script>
    // Simple toggle for mobile menu
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');
        
        if (mobileMenuButton && mobileMenu) {
            mobileMenuButton.addEventListener('click', function() {
                mobileMenu.classList.toggle('hidden');
            });
        }
    });
</script>