{{-- resources/views/partials/navbar.blade.php --}}

<!-- Italian tricolour stripe + Savoy‐blue accent -->
<div class="h-1.5 bg-gradient-to-r from-italy-green via-italy-white to-italy-red">
  <div class="h-full w-1/6 bg-italy-blue"></div>
</div>

<header class="sticky top-0 z-50 bg-white dark:bg-navy-900 dark:text-italy-white shadow-md">
  <div class="mx-auto flex max-w-6xl items-center justify-between px-4 py-3">
    <!-- Logo + Brand -->
    <a href="{{ route('home') }}" class="flex items-center space-x-2">
      <img src="{{ asset('cils04/icons/favicon-32x32.png') }}" alt="Logo" class="h-8 w-8"/>
      <span class="text-xl font-semibold">La Parola del Giorno</span>
    </a>

    <!-- Desktop nav -->
    <nav class="hidden md:flex space-x-6 text-sm font-medium">
      @foreach ([
        'home'      => 'Home',
        'subscribe' => 'Subscribe',
        'login'     => 'Login',
        'register'  => 'Register',
        'privacy'   => 'Privacy',
        'terms'     => 'Terms',
        'contact'   => 'Contact',
        'support'   => 'Support',
      ] as $route => $label)
        <a
          href="{{ route($route) }}"
          class="transition hover:text-italy-blue dark:hover:text-italy-white/80
            {{ request()->routeIs($route) 
                ? 'text-italy-blue dark:text-italy-white font-semibold' 
                : 'text-gray-700 dark:text-gray-300' }}"
          aria-current="{{ request()->routeIs($route) ? 'page' : null }}"
        >
          {{ $label }}
        </a>
      @endforeach
    </nav>

    <!-- Mobile menu button -->
    <button
      class="md:hidden p-2 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-navy-700 rounded"
      onclick="document.getElementById('mobile-menu').classList.toggle('hidden')"
      aria-label="Toggle navigation"
    >
      <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none"
           viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round"
              d="M4 6h16M4 12h16M4 18h16"/>
      </svg>
    </button>
  </div>

  <!-- Mobile nav drawer -->
  <nav
    id="mobile-menu"
    class="hidden md:hidden border-t border-gray-200 dark:border-navy-700 bg-white dark:bg-navy-900"
  >
    @foreach ([
      'home'      => 'Home',
      'subscribe' => 'Subscribe',
      'login'     => 'Login',
      'register'  => 'Register',
      'privacy'   => 'Privacy',
      'terms'     => 'Terms',
      'contact'   => 'Contact',
      'support'   => 'Support',
    ] as $route => $label)
      <a
        href="{{ route($route) }}"
        class="block px-4 py-2 text-sm font-medium transition hover:text-italy-blue dark:hover:text-italy-white/80
          {{ request()->routeIs($route) 
              ? 'text-italy-blue dark:text-italy-white font-semibold' 
              : 'text-gray-700 dark:text-gray-300' }}"
      >
        {{ $label }}
      </a>
    @endforeach
  </nav>
</header>
