{{-- resources/views/privacy.blade.php --}}
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy – CILS B1 Platform</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-italy-white dark:bg-navy-900 text-navy-900 dark:text-italy-white font-sans antialiased min-h-screen flex flex-col">
    <x-header>Privacy Policy</x-header>

    <main class="flex-grow container mx-auto px-4 py-12 max-w-3xl">
        <h1 class="text-3xl font-bold text-italy-blue mb-6">Informativa sulla Privacy</h1>
        <div class="bg-white dark:bg-navy-800 shadow rounded-lg p-8 text-gray-700 dark:text-gray-200 space-y-6">
            <p>
                La tua privacy è molto importante per noi. Questa informativa descrive come raccogliamo, utilizziamo e proteggiamo i tuoi dati personali in conformità al GDPR e alle leggi italiane vigenti.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">Raccolta delle informazioni</h2>
            <p>
                Raccogliamo solo le informazioni necessarie per offrirti i nostri servizi, come nome, email, e dati di utilizzo della piattaforma. Non condividiamo i tuoi dati con terzi non autorizzati.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">Utilizzo dei dati</h2>
            <p>
                Utilizziamo i dati raccolti per fornirti accesso ai servizi, migliorare l’esperienza utente, inviare comunicazioni pertinenti e garantire la sicurezza della piattaforma.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">Diritti dell’utente</h2>
            <p>
                Puoi richiedere in qualsiasi momento la modifica o la cancellazione dei tuoi dati personali. Per esercitare i tuoi diritti, contattaci tramite la sezione <a href="{{ route('contact') }}" class="text-italy-blue underline">Contatti</a>.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">Cookie e tecnologie simili</h2>
            <p>
                Utilizziamo cookie tecnici e di analisi per migliorare la navigazione e raccogliere informazioni anonime sulle visite. Puoi gestire le preferenze cookie dal tuo browser.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">Modifiche alla policy</h2>
            <p>
                Ci riserviamo il diritto di aggiornare la presente informativa. Eventuali cambiamenti saranno comunicati tramite il sito.
            </p>
        </div>
        <div class="text-center mt-8">
            <a href="{{ route('index') }}" class="text-italy-blue font-semibold hover:underline">Torna alla Home</a>
        </div>
    </main>

    @include('partials.footer')
</body>
</html>
