{{-- resources/views/register.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrati – CILS B1 Platform</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-italy-white dark:bg-navy-900 text-navy-900 dark:text-italy-white font-sans antialiased min-h-screen flex flex-col">
    <x-header>Register</x-header>

    <main class="flex-grow container mx-auto px-4 py-16 flex flex-col items-center justify-center">
        <div class="bg-white dark:bg-navy-800 shadow-xl rounded-lg p-8 w-full max-w-md">
            <h1 class="text-2xl font-bold text-center text-italy-blue mb-6">Crea un nuovo account</h1>
            <form method="POST" action="{{ url('/register') }}" class="space-y-6">
                @csrf
                <div>
                    <label for="name" class="block font-semibold mb-2">Nome completo</label>
                    <input id="name" name="name" type="text" required autofocus
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <div>
                    <label for="email" class="block font-semibold mb-2">Email</label>
                    <input id="email" name="email" type="email" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <div>
                    <label for="password" class="block font-semibold mb-2">Password</label>
                    <input id="password" name="password" type="password" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <div>
                    <label for="password_confirmation" class="block font-semibold mb-2">Conferma Password</label>
                    <input id="password_confirmation" name="password_confirmation" type="password" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <button type="submit"
                        class="w-full py-3 bg-italy-green text-white font-semibold rounded-lg shadow hover:bg-green-700 transition">
                    Registrati
                </button>
            </form>
            <p class="mt-6 text-center text-gray-700 dark:text-gray-200">
                Hai già un account?
                <a href="{{ route('login') }}" class="text-italy-blue font-semibold hover:underline">Accedi</a>
            </p>
        </div>
    </main>

    @include('partials.footer')
</body>
</html>
