{{-- resources/views/subscribe.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Abbonamenti – CILS B1 Platform</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-italy-white dark:bg-navy-900 text-navy-900 dark:text-italy-white font-sans antialiased min-h-screen flex flex-col">
    <x-header>Subscribe</x-header>

    <main class="flex-grow container mx-auto px-4 py-16">
        <section class="max-w-3xl mx-auto bg-white dark:bg-navy-800 shadow-xl rounded-lg p-8">
            <h1 class="text-3xl font-bold text-center text-italy-blue mb-4">Abbonati alla versione Premium</h1>
            <p class="text-center text-lg text-gray-700 dark:text-gray-200 mb-8">
                Ottieni l’accesso completo a tutti i moduli CILS, esercizi illimitati, report dettagliati, flashcard avanzate, correzione AI e supporto prioritario.
            </p>
            <div class="grid md:grid-cols-2 gap-8">
                <div class="border border-italy-blue rounded-lg p-6 flex flex-col items-center bg-blue-50 dark:bg-navy-700">
                    <h2 class="text-xl font-bold text-italy-blue mb-2">Gratuito</h2>
                    <ul class="list-disc list-inside text-gray-700 dark:text-gray-200 mb-4 text-sm">
                        <li>Accesso a esercizi di base</li>
                        <li>Quiz a risposta multipla</li>
                        <li>Statistiche essenziali</li>
                    </ul>
                    <span class="text-2xl font-bold text-italy-blue mb-4">€0</span>
                    @auth
                        <span class="inline-block bg-green-100 text-green-800 px-3 py-1 rounded font-semibold">Attivo</span>
                    @else
                        <a href="{{ route('register') }}" class="px-6 py-2 mt-2 bg-italy-blue text-white rounded-lg font-semibold hover:bg-blue-700 transition">Iscriviti gratis</a>
                    @endauth
                </div>
                <div class="border-2 border-italy-green rounded-lg p-6 flex flex-col items-center bg-green-50 dark:bg-navy-600 shadow-lg">
                    <h2 class="text-xl font-bold text-italy-green mb-2">Premium</h2>
                    <ul class="list-disc list-inside text-gray-700 dark:text-gray-200 mb-4 text-sm">
                        <li>Accesso illimitato a tutte le simulazioni</li>
                        <li>Correzione AI avanzata</li>
                        <li>Reportistica dettagliata sui progressi</li>
                        <li>Flashcard Premium e audio interattivi</li>
                        <li>Supporto prioritario e area esclusiva</li>
                    </ul>
                    <span class="text-2xl font-bold text-italy-green mb-4">€19,99/mese</span>
                    @auth
                        @if(auth()->user()->is_premium)
                            <span class="inline-block bg-green-700 text-white px-3 py-1 rounded font-semibold">Premium attivo</span>
                        @else
                            <form method="POST" action="{{ route('premium.subscribe') }}">
                                @csrf
                                <button type="submit" class="px-6 py-2 mt-2 bg-italy-green text-white rounded-lg font-semibold hover:bg-green-800 transition">
                                    Passa a Premium
                                </button>
                            </form>
                        @endif
                    @else
                        <a href="{{ route('register') }}" class="px-6 py-2 mt-2 bg-italy-green text-white rounded-lg font-semibold hover:bg-green-800 transition">Abbonati ora</a>
                    @endauth
                </div>
            </div>
            <div class="text-center mt-8">
                <a href="{{ route('contact') }}" class="text-italy-blue font-semibold hover:underline">Hai domande? Contattaci!</a>
            </div>
        </section>
    </main>

    @include('partials.footer')
</body>
</html>
