{{-- resources/views/support.blade.php --}}
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supporto – CILS B1 Platform</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-italy-white dark:bg-navy-900 text-navy-900 dark:text-italy-white font-sans antialiased min-h-screen flex flex-col">
    <x-header>Subscribe</x-header> 

    <main class="flex-grow container mx-auto px-4 py-16 flex flex-col items-center justify-center">
        <div class="bg-white dark:bg-navy-800 shadow-xl rounded-lg p-8 w-full max-w-lg">
            <h1 class="text-3xl font-bold text-italy-blue mb-6 text-center">Supporto e Assistenza</h1>
            <p class="mb-6 text-center text-gray-700 dark:text-gray-200">
                Per problemi tecnici, domande sull’abbonamento, richieste di fatturazione o altre necessità, puoi aprire un ticket di assistenza tramite questo modulo.
            </p>
            <form method="POST" action="{{ route('support') }}" class="space-y-6">
                @csrf
                <div>
                    <label for="subject" class="block font-semibold mb-2">Oggetto</label>
                    <input id="subject" name="subject" type="text" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <div>
                    <label for="email" class="block font-semibold mb-2">Email</label>
                    <input id="email" name="email" type="email" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"/>
                </div>
                <div>
                    <label for="description" class="block font-semibold mb-2">Descrizione del problema</label>
                    <textarea id="description" name="description" rows="5" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-navy-700 bg-gray-50 dark:bg-navy-900 text-gray-900 dark:text-italy-white focus:outline-none focus:ring-2 focus:ring-italy-blue"></textarea>
                </div>
                <button type="submit"
                        class="w-full py-3 bg-italy-green text-white font-semibold rounded-lg shadow hover:bg-green-700 transition">
                    Invia Richiesta di Supporto
                </button>
            </form>
            <p class="mt-6 text-center text-gray-700 dark:text-gray-200">
                Per risposte rapide, consulta anche le <a href="{{ route('terms') }}" class="text-italy-blue underline">FAQ e Termini</a>.
            </p>
        </div>
    </main>

    @include('partials.footer')
</body>
</html>
