{{-- resources/views/terms.blade.php --}}
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Termini e Condizioni – CILS B1 Platform</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-italy-white dark:bg-navy-900 text-navy-900 dark:text-italy-white font-sans antialiased min-h-screen flex flex-col">
    @include('partials.header')

    <main class="flex-grow container mx-auto px-4 py-12 max-w-3xl">
        <h1 class="text-3xl font-bold text-italy-blue mb-6">Termini e Condizioni</h1>
        <div class="bg-white dark:bg-navy-800 shadow rounded-lg p-8 text-gray-700 dark:text-gray-200 space-y-6">
            <p>
                Utilizzando la piattaforma CILS B1, accetti i seguenti termini e condizioni. Leggi attentamente questa sezione prima di utilizzare i nostri servizi.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">1. Oggetto del servizio</h2>
            <p>
                La piattaforma offre strumenti digitali per la preparazione all’esame di cittadinanza italiana (CILS B1). I contenuti sono a scopo didattico e non sostituiscono l’esame ufficiale.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">2. Account e accesso</h2>
            <p>
                Gli utenti sono responsabili della sicurezza del proprio account e delle informazioni di accesso. È vietata la condivisione delle credenziali.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">3. Abbonamento e pagamenti</h2>
            <p>
                Le funzionalità Premium sono accessibili tramite abbonamento. I pagamenti sono gestiti in modo sicuro; non conserviamo i dati delle carte di credito sul nostro server.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">4. Proprietà intellettuale</h2>
            <p>
                Tutti i contenuti, software e marchi presenti sulla piattaforma sono di proprietà esclusiva di CILS B1 Platform o dei suoi licenziatari. È vietata la riproduzione non autorizzata.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">5. Limitazioni di responsabilità</h2>
            <p>
                La piattaforma non garantisce il superamento dell’esame CILS. I servizi sono forniti "così come sono" e decliniamo ogni responsabilità per danni indiretti o incidentali.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">6. Modifiche ai termini</h2>
            <p>
                Ci riserviamo il diritto di modificare i termini e le condizioni. Gli utenti saranno informati tramite aggiornamenti sul sito.
            </p>

            <h2 class="text-xl font-bold text-italy-green mt-4">7. Contatti</h2>
            <p>
                Per domande o assistenza, consulta la sezione <a href="{{ route('contact') }}" class="text-italy-blue underline">Contatti</a>.
            </p>
        </div>
        <div class="text-center mt-8">
            <a href="{{ route('index') }}" class="text-italy-blue font-semibold hover:underline">Torna alla Home</a>
        </div>
    </main>

    @include('partials.footer')
</body>
</html>
