<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// Controllers
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\ContentController;
use App\Api\GamificationController;
use App\Api\SpeakingController;
use App\Api\AdaptiveController;
use App\Api\AdminController    as ApiAdminController;
use App\Api\WordEmailController;

/*
|--------------------------------------------------------------------------
| Public Authentication & Content Endpoints
|--------------------------------------------------------------------------
*/
Route::post('/auth/login',           [AuthController::class,   'login']);
Route::post('/auth/register',        [AuthController::class,   'register']);
Route::post('/auth/logout',          [AuthController::class,   'logout']);
Route::post('/auth/forgot-password', [AuthController::class,   'forgotPassword']);

Route::get('/user/profile',           [UserController::class,   'profile']);
Route::get('/user/flashcards/random', [UserController::class,   'flashcardRandom']);
Route::post('/user/flashcards/answer',[UserController::class,   'flashcardAnswer']);
Route::get('/user/subscription',      [UserController::class,   'subscription']);
Route::post('/user/subscription/cancel', [UserController::class,'cancelSubscription']);

Route::get('/admin/ai-models',        [AdminController::class,  'listAIModels']);
Route::post('/admin/ai-models/toggle/{id}', [AdminController::class, 'toggleAIModel']);
Route::get('/admin/subscriptions',    [AdminController::class,  'manageSubscriptions']);
Route::get('/admin/seo-settings',     [AdminController::class,  'manageSEOSettings']);
Route::get('/admin/posts',            [AdminController::class,  'managePosts']);
Route::post('/admin/posts/toggle/{id}', [AdminController::class, 'togglePostPublish']);

Route::get('/user/support/tickets',   [SupportController::class, 'listTickets']);
Route::post('/user/support/create',   [SupportController::class, 'createTicket']);
Route::post('/admin/support/reply/{id}', [SupportController::class,'replyTicket']);

Route::get('/user/word-of-the-day',   [ContentController::class, 'wordOfTheDay']);
Route::get('/user/listening/random',  [ContentController::class, 'listeningRandom']);
Route::post('/user/speaking/upload',  [ContentController::class, 'speakingUpload']);

/*
|--------------------------------------------------------------------------
| Authenticated User & Gamification Endpoints
|--------------------------------------------------------------------------
*/
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/gamification/award',        [GamificationController::class, 'award']);
    Route::get('/user/gamification/overview', [GamificationController::class, 'overview']);
    Route::get('/user/gamification/quest',    [GamificationController::class, 'quest']);

    Route::post('/user/speaking/upload',      [SpeakingController::class, 'upload']);
    Route::post('/user/diagnostic/submit',    [AdaptiveController::class, 'submitDiagnostic']);
});

/*
|--------------------------------------------------------------------------
| Admin-Only Stats & Email Settings
|--------------------------------------------------------------------------
*/
Route::get('/admin/stats', [ApiAdminController::class, 'stats']);

Route::middleware(['auth:sanctum', 'admin'])
     ->prefix('admin/word-email')
     ->group(function () {
         Route::get('/',         [WordEmailController::class, 'index']);
         Route::post('/word',    [WordEmailController::class, 'storeWord']);
         Route::post('/template',[WordEmailController::class, 'saveTemplate']);
         Route::post('/ads',     [WordEmailController::class, 'saveAds']);
     });
