<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Public Blade Views
|--------------------------------------------------------------------------
| These load standalone Blade templates in resources/views/*.blade.php
*/
Route::view('/',          'index')     ->name('home');
Route::view('/subscribe', 'subscribe') ->name('subscribe');
Route::view('/login',     'login')     ->name('login');
Route::view('/register',  'register')  ->name('register');
Route::view('/privacy',   'privacy')   ->name('privacy');
Route::view('/terms',     'terms')     ->name('terms');
Route::view('/contact',   'contact')   ->name('contact');
Route::view('/support',   'support')   ->name('support');

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
| Leave these alone so your SPA can fetch data under /api/…
*/
Route::prefix('api')->group(function () {
    require __DIR__ . '/api.php';
});

/*
|--------------------------------------------------------------------------
| SPA Fallback
|--------------------------------------------------------------------------
| Everything else (non‐API) should load the Vue/Tailwind SPA shell.
*/
Route::get('/{any}', fn () => view('app'))
     ->where('any', '^(?!api).*$')
     ->name('spa');
