<?php
namespace App\Services\AI;

use Illuminate\Support\Facades\Http;

class SpeechGraderClient
{
    public function grade(string $filePath): array
    {
        $response = Http::attach('file', file_get_contents($filePath), 'speech.wav')
            ->post(config('ai.speech_grader').'/grade');
        return $response->json();
    }
}

class QuestionGeneratorClient
{
    public function generate(string $passage, int $n=4): array
    {
        $response = Http::post(config('ai.question_generator').'/generate', [
            'passage'=>$passage, 'n'=>$n
        ]);
        return $response->json('questions');
    }
}

class SimilarityScorerClient
{
    public function score(string $reference, string $answer): float
    {
        $response = Http::post(config('ai.similarity_scorer').'/score', [
            'reference'=>$reference, 'answer'=>$answer
        ]);
        return (float)$response->json('similarity');
    }
}
