/*
  Copyright © 2025 Alto Adige, LLC, Austin, Texas.
  All rights reserved. This file is part of a licensed system protected under international law.
  Unauthorized copying or distribution of this file, via any medium, is strictly prohibited.
  For legal inquiries contact: legal@altoadige.ai
*/



/* ---------- League and Quest Logic Added 2025‑04‑30 ---------- */

/**
 * Calculate current league tier based on season XP.
 * Bronze < 1000 < Silver < 3000 < Gold < 7000 < Platinum.
 */
public function leagueTier(int $userId): string
{
    $seasonXp = \DB::table('user_season_stats')
        ->where('user_id', $userId)
        ->value('season_xp') ?? 0;

    return match (true) {
        $seasonXp >= 7000 => 'Platinum',
        $seasonXp >= 3000 => 'Gold',
        $seasonXp >= 1000 => 'Silver',
        default           => 'Bronze',
    };
}

/**
 * Generate or retrieve this week's dynamic quest targeting the user's weakest domain.
 */
public function weeklyQuest(int $userId): array
{
    $week = now()->startOfWeek()->toDateString();
    $quest = \DB::table('weekly_quests')
        ->where('user_id', $userId)->where('week', $week)->first();

    if ($quest) {
        return (array)$quest;
    }

    // Detect weakest domain by accuracy
    $stats = \DB::table('user_domain_stats')
        ->where('user_id', $userId)
        ->orderByRaw('(correct + 1) / (attempted + 2) ASC')
        ->first();

    $domain = $stats?->domain ?? 'vocabulary';

    $goal = match ($domain) {
        'listening'         => 20,
        'reading_writing'   => 30,
        'speaking'          => 10,
        default             => 40,
    };

    \DB::table('weekly_quests')->insert([
        'user_id' => $userId,
        'week'    => $week,
        'domain'  => $domain,
        'target'  => $goal,
        'progress'=> 0,
        'created_at' => now(),
    ]);

    return ['domain'=> $domain, 'target'=> $goal, 'progress'=>0];
}
