<?php
namespace App\Services;

use Illuminate\Support\Facades\Storage;
use Smalot\PdfParser\Parser as PdfParser;
use PhpOffice\PhpWord\IOFactory;
use App\Services\AI\QuestionGeneratorClient;
use Illuminate\Support\Str;

class QuestionParser
{
    public function __construct(private QuestionGeneratorClient $qgen){}

    public function parseDocument(string $path, int $userId): void
    {
        $text = '';
        $ext = Str::lower(pathinfo($path, PATHINFO_EXTENSION));
        if ($ext==='pdf') {
            $parser = new PdfParser();
            $pdf = $parser->parseFile(Storage::path($path));
            $text = $pdf->getText();
        } elseif ($ext==='docx') {
            $phpWord = IOFactory::load(Storage::path($path), 'Word2007');
            foreach($phpWord->getSections() as $section){
                foreach($section->getElements() as $el){
                    if(method_exists($el,'getText')) $text .= $el->getText()."\n";
                }
            }
        } else {
            $text = Storage::get($path);
        }

        $questions = $this->qgen->generate(Str::limit($text, 2000));
        // store questions...
    }

    public function parseZip(string $path, int $userId): void
    {
        $tmp = sys_get_temp_dir().'/ingest_'.uniqid().'.zip';
        Storage::disk('local')->copy($path, $tmp);
        $zip = new \ZipArchive();
        $zip->open($tmp);
        for($i=0;$i<$zip->numFiles;$i++){
            $entry = $zip->getNameIndex($i);
            $ext = Str::lower(pathinfo($entry,PATHINFO_EXTENSION));
            if(in_array($ext,['pdf','docx','txt','mp3','wav','ogg','mp4'])){
                // Extract and dispatch self for each
            }
        }
        $zip->close();
    }

    public function parseAudio(string $path, int $userId): void
    {
        // store audio path for listening tasks
    }
}
