
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['url' => config('app.url')]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['url' => config('app.url')]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<header class="bg-white shadow-sm py-4 mb-8">
    <div class="container mx-auto px-4 md:px-6">
        <div class="flex justify-between items-center">
            <a href="<?php echo e($url); ?>" class="text-[#0055A4] font-bold text-xl">
                <?php if(trim($slot) === 'Laravel'): ?>
                    <img src="<?php echo e(asset('icons/apple-touch-icon.png')); ?>" alt="CILS B1 Logo" class="h-10 w-auto">
                <?php else: ?>
                    <?php echo e($slot); ?>

                <?php endif; ?>
            </a>
            
            <nav class="hidden md:flex space-x-6">
                <a href="<?php echo e(url('/')); ?>" class="text-gray-800 hover:text-[#0055A4]">Home</a>
                <a href="<?php echo e(url('/register')); ?>" class="text-gray-800 hover:text-[#0055A4]">Register</a>
                <a href="<?php echo e(url('/contact')); ?>" class="text-gray-800 hover:text-[#0055A4]">Contact</a>
                <a href="<?php echo e(url('/support')); ?>" class="text-gray-800 hover:text-[#0055A4]">Support</a>
            </nav>
            
            <div class="md:hidden">
                <button id="mobile-menu-button" class="text-gray-800 hover:text-[#0055A4]">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
            </div>
        </div>
        
        <!-- Mobile menu (hidden by default) -->
        <div id="mobile-menu" class="md:hidden hidden mt-4">
            <nav class="flex flex-col space-y-4">
                <a href="<?php echo e(url('/')); ?>" class="text-gray-800 hover:text-[#0055A4]">Home</a>
                <a href="<?php echo e(url('/register')); ?>" class="text-gray-800 hover:text-[#0055A4]">Register</a>
                <a href="<?php echo e(url('/contact')); ?>" class="text-gray-800 hover:text-[#0055A4]">Contact</a>
                <a href="<?php echo e(url('/support')); ?>" class="text-gray-800 hover:text-[#0055A4]">Support</a>
            </nav>
        </div>
    </div>
</header>

<script>
    // Simple toggle for mobile menu
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');
        
        if (mobileMenuButton && mobileMenu) {
            mobileMenuButton.addEventListener('click', function() {
                mobileMenu.classList.toggle('hidden');
            });
        }
    });
</script><?php /**PATH /home/seppemwn/public_html/cils04/resources/views/partials/header.blade.php ENDPATH**/ ?>