
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="scroll-smooth antialiased">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <title><?php echo $__env->yieldContent('title','CILS B1 Platform – App'); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('description','Preparazione digitale CILS B1 con AI, flashcard, simulazioni e supporto multilingua.'); ?>" />
    <meta name="theme-color" content="#0055A4" />

    
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('icons/apple-touch-icon.png')); ?>" />
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('icons/favicon-32x32.png')); ?>" />
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('icons/favicon-16x16.png')); ?>" />
    <link rel="manifest" href="<?php echo e(asset('manifest.json')); ?>" />

    
    <?php echo app('Illuminate\Foundation\Vite')('src/main.js'); ?>
</head>
<body class="bg-italy-white text-navy-900 font-sans dark:bg-navy-900 dark:text-italy-white min-h-screen">

    
    <div id="app"></div>

    
    <script type="module">
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () =>
                navigator.serviceWorker.register('/sw.js')
            );
        }
    </script>
    
    <script type="module"
        src="https://unpkg.com/ionicons@6.0.3/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule
        src="https://unpkg.com/ionicons@6.0.3/dist/ionicons/ionicons.js"></script>
</body>
</html>
<?php /**PATH /home/seppemwn/public_html/cils04/resources/views/app.blade.php ENDPATH**/ ?>