
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Abbonamenti – CILS B1 Platform</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-italy-white dark:bg-navy-900 text-navy-900 dark:text-italy-white font-sans antialiased min-h-screen flex flex-col">
    <?php if (isset($component)) { $__componentOriginalfd1f218809a441e923395fcbf03e4272 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfd1f218809a441e923395fcbf03e4272 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.header','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>Subscribe <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfd1f218809a441e923395fcbf03e4272)): ?>
<?php $attributes = $__attributesOriginalfd1f218809a441e923395fcbf03e4272; ?>
<?php unset($__attributesOriginalfd1f218809a441e923395fcbf03e4272); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfd1f218809a441e923395fcbf03e4272)): ?>
<?php $component = $__componentOriginalfd1f218809a441e923395fcbf03e4272; ?>
<?php unset($__componentOriginalfd1f218809a441e923395fcbf03e4272); ?>
<?php endif; ?>

    <main class="flex-grow container mx-auto px-4 py-16">
        <section class="max-w-3xl mx-auto bg-white dark:bg-navy-800 shadow-xl rounded-lg p-8">
            <h1 class="text-3xl font-bold text-center text-italy-blue mb-4">Abbonati alla versione Premium</h1>
            <p class="text-center text-lg text-gray-700 dark:text-gray-200 mb-8">
                Ottieni l’accesso completo a tutti i moduli CILS, esercizi illimitati, report dettagliati, flashcard avanzate, correzione AI e supporto prioritario.
            </p>
            <div class="grid md:grid-cols-2 gap-8">
                <div class="border border-italy-blue rounded-lg p-6 flex flex-col items-center bg-blue-50 dark:bg-navy-700">
                    <h2 class="text-xl font-bold text-italy-blue mb-2">Gratuito</h2>
                    <ul class="list-disc list-inside text-gray-700 dark:text-gray-200 mb-4 text-sm">
                        <li>Accesso a esercizi di base</li>
                        <li>Quiz a risposta multipla</li>
                        <li>Statistiche essenziali</li>
                    </ul>
                    <span class="text-2xl font-bold text-italy-blue mb-4">€0</span>
                    <?php if(auth()->guard()->check()): ?>
                        <span class="inline-block bg-green-100 text-green-800 px-3 py-1 rounded font-semibold">Attivo</span>
                    <?php else: ?>
                        <a href="<?php echo e(route('register')); ?>" class="px-6 py-2 mt-2 bg-italy-blue text-white rounded-lg font-semibold hover:bg-blue-700 transition">Iscriviti gratis</a>
                    <?php endif; ?>
                </div>
                <div class="border-2 border-italy-green rounded-lg p-6 flex flex-col items-center bg-green-50 dark:bg-navy-600 shadow-lg">
                    <h2 class="text-xl font-bold text-italy-green mb-2">Premium</h2>
                    <ul class="list-disc list-inside text-gray-700 dark:text-gray-200 mb-4 text-sm">
                        <li>Accesso illimitato a tutte le simulazioni</li>
                        <li>Correzione AI avanzata</li>
                        <li>Reportistica dettagliata sui progressi</li>
                        <li>Flashcard Premium e audio interattivi</li>
                        <li>Supporto prioritario e area esclusiva</li>
                    </ul>
                    <span class="text-2xl font-bold text-italy-green mb-4">€19,99/mese</span>
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->is_premium): ?>
                            <span class="inline-block bg-green-700 text-white px-3 py-1 rounded font-semibold">Premium attivo</span>
                        <?php else: ?>
                            <form method="POST" action="<?php echo e(route('premium.subscribe')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="px-6 py-2 mt-2 bg-italy-green text-white rounded-lg font-semibold hover:bg-green-800 transition">
                                    Passa a Premium
                                </button>
                            </form>
                        <?php endif; ?>
                    <?php else: ?>
                        <a href="<?php echo e(route('register')); ?>" class="px-6 py-2 mt-2 bg-italy-green text-white rounded-lg font-semibold hover:bg-green-800 transition">Abbonati ora</a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="text-center mt-8">
                <a href="<?php echo e(route('contact')); ?>" class="text-italy-blue font-semibold hover:underline">Hai domande? Contattaci!</a>
            </div>
        </section>
    </main>

    <?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</body>
</html>
<?php /**PATH /home/seppemwn/public_html/cils04/resources/views/subscribe.blade.php ENDPATH**/ ?>