/* tailwind.config.js */
import forms  from '@tailwindcss/forms';
import plugin from 'tailwindcss/plugin';

export default {
  content: [
    './resources/**/*.blade.php',
    './resources/**/*.vue',
    './resources/**/*.js',
  ],

  theme: {
    container: {
      center: true,
      padding: '2rem',
    },

    extend: {
      /*  Brand palette derived from the Italian flag + accent blue  */
      colors: {
        italian: {
          green: '#009246',
          white: '#ffffff',
          red:   '#ce2b37',
        },

        /* accent colour used by ring utilities */
        'italy-blue': '#0066cc',

        /*  Semantic tokens bound to CSS custom properties  */
        primary:              'hsl(var(--primary) / <alpha-value>)',
        'primary-foreground': 'hsl(var(--primary-foreground) / <alpha-value>)',

        secondary:              'hsl(var(--secondary) / <alpha-value>)',
        'secondary-foreground': 'hsl(var(--secondary-foreground) / <alpha-value>)',

        background: 'hsl(var(--background) / <alpha-value>)',
        foreground: 'hsl(var(--foreground) / <alpha-value>)',
      },

      /* Make sure ring-italy-blue exists */
      ringColor: {
        'italy-blue': '#0066cc',
      },

      fontFamily: {
        sans:  ['Inter', 'ui-sans-serif', 'system-ui'],
        serif: ['"Playfair Display"', 'ui-serif', 'Georgia'],
      },
    },
  },

  plugins: [
    forms,

    /* Utility class for the navigation links in the header partial */
    plugin(({ addComponents }) => {
      addComponents({
        '.nav-link': {
          '@apply text-sm font-medium text-slate-700 hover:text-[color:var(--primary)] transition-colors':
            {},
        },
      });
    }),
  ],
};