<?php
namespace Utils;

use PDO;

class Database
{
    private static ?PDO $conn = null;

    public static function getConnection(): PDO
    {
        if (self::$conn === null) {
            $host     = getenv('DB_HOST') ?: 'localhost';
            $database = getenv('DB_DATABASE') ?: 'cils04_db';
            $user     = getenv('DB_USERNAME') ?: 'cils04_user';
            $password = getenv('DB_PASSWORD') ?: 'secret';

            $dsn = sprintf('mysql:host=%s;dbname=%s;charset=utf8mb4', $host, $database);
            self::$conn = new PDO($dsn, $user, $password, [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            ]);
        }
        return self::$conn;
    }
}
