/**
 * vite.config.js — canonical layout for Laravel 10/11/12 + Vue 3
 *
 * • Vue SFCs live under resources/js
 * • Production build → public/build/**  (incl. manifest.json)
 * • Works out-of-the-box with Blade’s  @vite([...])
 */

import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';
import path from 'path';

export default defineConfig(({ mode }) => ({
  plugins: [
    laravel({
      /**
       * buildDirectory sets the folder inside /public/* where
       * hashed assets and manifest.json are written.
       *   buildDirectory: 'build'  →  public/build/…
       *
       * This is the officially recommended way; you no longer
       * need to fiddle with build.outDir manually.
       */
      buildDirectory: 'build',

      // Your entry points (feel free to add more)
      input: ['resources/css/app.css', 'resources/js/app.js'],

      // Enables automatic browser reload in `php artisan serve`
      refresh: true,
    }),

    vue(),
  ],

  /* ------------------------------------------------------------------ */
  /*  Module Resolution                                                 */
  /* ------------------------------------------------------------------ */
  resolve: {
    alias: {
      '@': path.resolve(__dirname, 'resources/js'),
    },
    extensions: ['.js', '.ts', '.jsx', '.tsx', '.vue', '.json'],
  },

  /* ------------------------------------------------------------------ */
  /*  Roll-up / Build Customisation                                     */
  /* ------------------------------------------------------------------ */
  build: {
    // outDir is injected by the plugin (public/build)
    emptyOutDir: true,
    // manifest: true,

    rollupOptions: {
      output: {
        /**
         * Put every top-level node_modules package into its own
         * chunk: vendor, axios, vue, etc. → better browser caching.
         */
        manualChunks(id) {
          if (id.includes('node_modules')) {
            return id.split('node_modules/')[1].split('/')[0];
          }
        },

        // Consistent hashed filenames:
        assetFileNames: 'assets/[name]-[hash][extname]',
        chunkFileNames: 'assets/[name]-[hash].js',
        entryFileNames: 'assets/[name]-[hash].js',
      },
    },
  },

  /* ------------------------------------------------------------------ */
  /*  Dev Server (vite serve)                                           */
  /* ------------------------------------------------------------------ */
  server: {
    host: '0.0.0.0',
    port: 5173,
    strictPort: true,
    proxy: {
      '/api': {
        target: 'http://localhost:8000',
        changeOrigin: true,
        secure: false,
      },
    },
  },

  /* ------------------------------------------------------------------ */
  /*  Dependency Pre-bundling                                           */
  /* ------------------------------------------------------------------ */
  optimizeDeps: {
    include: ['vue', 'vue-router', 'pinia', 'axios'],
  },
}));