// workbox-config.cjs
module.exports = {
  // 1. Where your final built files live:
  globDirectory: "public",
  // 2. Which files to precache:
  globPatterns: [
    "manifest.json",
    "build/**/*.{js,css,html,png,svg,ico,json}"
  ],
  // 3. Name & location of the generated service worker:
  swDest: "public/sw.js",

  // 4. Ensure the SW takes control as soon as it's installed:
  clientsClaim: true,
  skipWaiting: true,

  // 5. A fallback so SPA navigations always return your index.html:
  navigateFallback: "/cils04/index.html",
  navigateFallbackDenylist: [
    // API calls, assets, etc.
    new RegExp("^/api/"),
    new RegExp("^/build/")
  ],

  // 6. Runtime caching beyond the precache list:
  runtimeCaching: [
    {
      // HTML pages: network first, then cache
      urlPattern: ({ request }) => request.destination === "document",
      handler: "NetworkFirst",
      options: {
        cacheName: "html-cache",
        expiration: {
          maxEntries: 20,
          maxAgeSeconds: 24 * 60 * 60 // 1 day
        }
      }
    },
    {
      // Images & icons: cache first
      urlPattern: /\.(?:png|jpg|jpeg|svg|ico)$/,
      handler: "CacheFirst",
      options: {
        cacheName: "image-cache",
        expiration: {
          maxEntries: 60,
          maxAgeSeconds: 7 * 24 * 60 * 60 // 1 week
        }
      }
    }
  ]
};
